<?php include 'includes/header.php'; ?>
<?php include 'includes/db.php'; ?>

<section class="blog-section">
    <h2 class="section-title">All Blogs</h2>
    <div class="blog-container">
        <?php
        $blogs = $conn->query("SELECT * FROM blog ORDER BY created_at DESC");
        if($blogs->num_rows > 0):
            while($blog = $blogs->fetch_assoc()):
                // Get first image for preview
                $img = $conn->query("SELECT image_path FROM blog_images WHERE blog_id=".$blog['id']." ORDER BY id ASC LIMIT 1")->fetch_assoc();
                $previewImage = $img ? $img['image_path'] : 'assets/images/default.jpg';
        ?>
        <div class="blog-card" style="background-image: url('<?= $previewImage ?>');">
            <div class="overlay"></div>
            <div class="blog-content">
                <h3><?= htmlspecialchars($blog['title']); ?></h3>
                <p><?= substr(strip_tags($blog['content']),0,150).'...'; ?></p>
                <a href="blogdetails.php?id=<?= $blog['id']; ?>" class="read-more">Read More →</a>
            </div>
        </div>
        <?php
            endwhile;
        else:
            echo "<p class='no-blog'>No blogs available.</p>";
        endif;
        ?>
    </div>
</section>

<style>
.blog-section {
    padding: 60px 0;
    background: #f8f9fa;
    text-align: center;
}

.section-title {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 40px;
    color: #333;
}

.blog-container {
    display: flex;
    justify-content: center;
    flex-wrap: wrap;
    gap: 20px;
}

.blog-card {
    position: relative;
    width: 320px;
    height: 260px;
    border-radius: 15px;
    overflow: hidden;
    background-size: cover;
    background-position: center;
    box-shadow: 0 4px 15px rgba(0,0,0,0.2);
    transition: transform 0.3s;
}

.blog-card:hover {
    transform: scale(1.03);
}

.blog-card .overlay {
    position: absolute;
    inset: 0;
    background: rgba(0,0,0,0.5);
}

.blog-content {
    position: absolute;
    bottom: 0;
    padding: 20px;
    color: #fff;
    text-align: left;
}

.blog-content h3 {
    font-size: 1.2rem;
    margin-bottom: 8px;
}

.blog-content p {
    font-size: 0.9rem;
    line-height: 1.3;
    margin-bottom: 10px;
}

.read-more {
    background: #ff6600;
    color: white;
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 0.85rem;
    text-decoration: none;
}

.read-more:hover {
    background: #ff8533;
}

.no-blog {
    color: #555;
    font-size: 1rem;
}
</style>

<?php include 'includes/footer.php'; ?>
