<?php include 'includes/header.php'; ?>
<?php include 'includes/db.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>News Feed</title>
<style>
body {
  background: #f9fafc;
  font-family: 'Segoe UI', sans-serif;
}

.news-container {
  width: 85%;
  margin: 60px auto;
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
  gap: 30px;
}

.news-card {
  position: relative;
  background: #fff;
  border-radius: 12px;
  overflow: hidden;
  box-shadow: 0 6px 20px rgba(0,0,0,0.1);
  transition: transform 0.3s;
}

.news-card:hover {
  transform: translateY(-5px);
}

.news-card img {
  width: 100%;
  height: 220px;
  object-fit: cover;
}

.news-content {
  padding: 20px;
}

.news-content h3 {
  font-size: 1.3rem;
  color: #1a237e;
  margin-bottom: 10px;
}

.news-content p {
  color: #555;
  font-size: 0.95rem;
  line-height: 1.6;
  height: 60px;
  overflow: hidden;
  text-overflow: ellipsis;
}

.news-content .btn {
  display: inline-block;
  margin-top: 10px;
  background: #007bff;
  color: white;
  padding: 8px 15px;
  border-radius: 6px;
  text-decoration: none;
  transition: background 0.3s;
}

.news-content .btn:hover {
  background: #0056b3;
}
</style>
</head>
<body>

<h2 style="text-align:center; margin-top:30px; color:#1a237e;">📰 Latest News</h2>

<div class="news-container">
<?php
// Get all news
$result = $conn->query("SELECT * FROM news ORDER BY id DESC");

while ($row = $result->fetch_assoc()):
    $newsId = $row['id'];

    // Get the first image from news_images table
    $imgResult = $conn->query("SELECT image_path FROM news_images WHERE news_id = $newsId LIMIT 1");
    if ($imgResult->num_rows > 0) {
        $imgRow = $imgResult->fetch_assoc();
        $imagePath = $imgRow['image_path'];
    } elseif (!empty($row['image'])) {
        // fallback to old single image column
        $imagePath = $row['image'];
    } else {
        // fallback placeholder
        $imagePath = 'assets/images/no-image.jpg';
    }

    // Shorten content
    $short = strip_tags($row['content']);
    $short = substr($short, 0, 150) . '...';
?>
  <div class="news-card">
    <img src="<?= htmlspecialchars($imagePath) ?>" alt="<?= htmlspecialchars($row['title']) ?>">
    <div class="news-content">
      <h3><?= htmlspecialchars($row['title']) ?></h3>
      <p><?= htmlspecialchars($short) ?></p>
      <a href="news-details.php?id=<?= $row['id'] ?>" class="btn">See More</a>
    </div>
  </div>
<?php endwhile; ?>
</div>

<?php include 'includes/footer.php'; ?>
</body>
</html>
