<?php 
include '../includes/db.php'; 
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Add Department</title>

<!-- TinyMCE -->
<script src="https://cdn.tiny.cloud/1/2nyevjbzoe9s0cqpit8eqinyyajkxjhanploe5k3zux76aq2/tinymce/7/tinymce.min.js" referrerpolicy="origin"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    tinymce.init({
        selector: '#description',
        height: 300,
        plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
        toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | forecolor backcolor | link image media emoticons | alignleft aligncenter alignright alignjustify | bullist numlist | removeformat | code',
        menubar: true,
        branding: false
    });
});
</script>

<style>
body { font-family: Arial, sans-serif; background: #f4f6f9; }
.container { max-width: 800px; margin: 50px auto; background: #fff; padding: 30px; border-radius: 10px; box-shadow: 0 4px 20px rgba(0,0,0,0.1); }
h2 { text-align: center; color: #1a237e; margin-bottom: 30px; }
form label { display: block; margin-bottom: 8px; font-weight: 600; color: #333; }
form input[type="text"], form input[type="file"], form textarea { width: 100%; padding: 10px; margin-bottom: 20px; border: 1px solid #ccc; border-radius: 8px; font-size: 1rem; }
form button { background: #1a237e; color: #fff; padding: 10px 20px; border: none; border-radius: 8px; cursor: pointer; font-size: 1rem; }
form button:hover { background: #3949ab; }
.success { background: #d4edda; color: #155724; padding: 12px; border-radius: 8px; margin-bottom: 20px; text-align: center; }
.error { background: #f8d7da; color: #721c24; padding: 12px; border-radius: 8px; margin-bottom: 20px; text-align: center; }
</style>
</head>
<body>

<div class="container">
<h2>Add New Department</h2>

<?php
if($_SERVER['REQUEST_METHOD'] === 'POST'){

    // Get form data
    $name = trim($_POST['name']);
    $description = trim($_POST['description']);

    // Validation
    if(empty($name) || empty($description)){
        echo "<p class='error'>⚠️ Please fill in all required fields!</p>";
    } else {

        // Insert department
        $stmt = $conn->prepare("INSERT INTO departments (name, description) VALUES (?, ?)");
        $stmt->bind_param("ss", $name, $description);

        if($stmt->execute()){
            $deptId = $stmt->insert_id;
            $stmt->close();

            // Handle multiple images
            if(!empty($_FILES['images']['name'][0])){
                $targetDir = "../uploads/departments/";
                if(!is_dir($targetDir)) mkdir($targetDir, 0777, true);

                foreach($_FILES['images']['name'] as $key => $imageName){
                    if(!empty($imageName)){
                        $tmpName = $_FILES['images']['tmp_name'][$key];
                        $ext = pathinfo($imageName, PATHINFO_EXTENSION);
                        $newName = $targetDir . time() . '_' . rand(1000,9999) . '.' . $ext;

                        if(move_uploaded_file($tmpName, $newName)){
                            $imgPath = "uploads/departments/" . basename($newName);
                            $imgStmt = $conn->prepare("INSERT INTO department_images (department_id, image_path) VALUES (?, ?)");
                            $imgStmt->bind_param("is", $deptId, $imgPath);
                            $imgStmt->execute();
                            $imgStmt->close();
                        }
                    }
                }
            }

            echo "<p class='success'>✅ Department added successfully!</p>";

        } else {
            echo "<p class='error'>❌ Failed to add department.</p>";
        }
    }
}
?>

<form method="POST" enctype="multipart/form-data">
    <label>Department Name:</label>
    <input type="text" name="name" placeholder="Enter department name">

    <label>Description:</label>
    <textarea name="description" id="description"></textarea>

    <label>Upload Images:</label>
    <input type="file" name="images[]" multiple accept="image/*">

    <button type="submit">Add Department</button>
</form>
</div>

</body>
</html>
