<?php include '../includes/auth.php'; ?>
<?php include '../includes/db.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Add News</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- TinyMCE -->
<script src="https://cdn.tiny.cloud/1/2nyevjbzoe9s0cqpit8eqinyyajkxjhanploe5k3zux76aq2/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    tinymce.init({
        selector: '#content',
        height: 400,
        plugins: 'advlist anchor autolink autocompleter autosave bbcode casechange charmap codesample colorpicker contextmenu directionality emoticons fullscreen help hr image importcss insertdatetime link lists media nonbreaking pagebreak paste preview print save searchreplace spellchecker table template textpattern toc visualblocks wordcount',
        toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | forecolor backcolor | link image media emoticons | alignleft aligncenter alignright alignjustify | bullist numlist checklist | outdent indent | blockquote removeformat | pagebreak | table | charmap codesample | insertdatetime | preview print | fullscreen',
        menubar: 'file edit view insert format tools table help',
        toolbar_mode: 'wrap',
        branding: false
    });
});
</script>

<style>
body { background: #f3f5f9; font-family: "Segoe UI", sans-serif; }
.admin-container {
    width: 80%; max-width: 900px; margin: 50px auto; background: #fff;
    padding: 30px 40px; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.1);
}
.admin-container h2 {
    text-align: center; margin-bottom: 25px; color: #333;
    font-size: 1.8rem; border-bottom: 2px solid #007bff; display: inline-block;
    padding-bottom: 5px;
}
.news-form { display: flex; flex-direction: column; gap: 15px; }
.news-form label { font-weight: bold; color: #444; }
.news-form input[type="text"], .news-form input[type="file"], .news-form textarea {
    padding: 10px; border: 1px solid #ccc; border-radius: 8px; font-size: 1rem; width: 100%;
}
.news-form input[type="file"] { background: #f9f9f9; }
.btn {
    width: 200px; background: #007bff; color: white; padding: 10px 15px;
    border: none; border-radius: 6px; cursor: pointer; font-weight: bold;
    transition: 0.3s; align-self: center;
}
.btn:hover { background: #0056b3; }
.success, .error {
    padding: 12px; border-radius: 6px; text-align: center; margin-bottom: 15px;
}
.success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
.error { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
</style>

</head>
<body>

<?php include '../includes/header.php'; ?>

<div class="admin-container">
    <h2>Add News</h2>

    <?php
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $title = trim($_POST['title']);
        $content = trim($_POST['content']);

        if (!empty($title) && !empty($content)) {
            $stmt = $conn->prepare("INSERT INTO news (title, content) VALUES (?, ?)");
            $stmt->bind_param("ss", $title, $content);

            if ($stmt->execute()) {
                $news_id = $stmt->insert_id;
                $stmt->close();

                $targetDir = "../uploads/news/";
                if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);

                $files = $_FILES['images'];
                for ($i = 0; $i < count($files['name']); $i++) {
                    if (!empty($files['name'][$i])) {
                        $fileName = time() . '_' . basename($files['name'][$i]);
                        $targetFile = $targetDir . $fileName;

                        if (move_uploaded_file($files['tmp_name'][$i], $targetFile)) {
                            $imagePath = "uploads/news/" . $fileName;
                            $imgStmt = $conn->prepare("INSERT INTO news_images (news_id, image_path) VALUES (?, ?)");
                            $imgStmt->bind_param("is", $news_id, $imagePath);
                            $imgStmt->execute();
                            $imgStmt->close();
                        }
                    }
                }

                echo "<p class='success'>✅ News with multiple images added successfully!</p>";
            } else {
                echo "<p class='error'>❌ Failed to save news.</p>";
            }
        } else {
            echo "<p class='error'>⚠️ Please fill in all required fields.</p>";
        }
    }
    ?>

    <form action="" method="POST" enctype="multipart/form-data" class="news-form">
        <label for="title">News Title:</label>
        <input type="text" name="title" id="title" required>

        <label for="images">Upload News Images (multiple allowed):</label>
        <input type="file" name="images[]" id="images" accept="image/*" multiple>

        <label for="content">News Content:</label>
        <textarea name="content" id="content"></textarea>

        <button type="submit" class="btn">Add News</button>
    </form>
</div>

<?php include '../includes/footer.php'; ?>

</body>
</html>
