<?php
include '../includes/db.php';
include '../includes/auth.php'; // session check

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $type = $_POST['type'];
    $title = $conn->real_escape_string($_POST['title']);
    $caption = $conn->real_escape_string($_POST['caption']); // TinyMCE HTML
    $position = $_POST['position'];

    $file_path_db = '';
    if (isset($_FILES['file']) && $_FILES['file']['error'] == 0) {
        $target_dir = "../assets/img/";
        if (!is_dir($target_dir)) mkdir($target_dir, 0755, true);

        $target_file = $target_dir . basename($_FILES["file"]["name"]);

        if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
            $file_path_db = "assets/img/" . basename($_FILES["file"]["name"]);
        }
    }

    $conn->query("INSERT INTO slider (type, file_path, title, caption, position)
                  VALUES ('$type', '$file_path_db', '$title', '$caption', '$position')");
    echo "<p style='color:green'>✅ Slide added successfully!</p>";
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Slider Settings</title>

</head>
<body>

<style>
@import url('https://fonts.googleapis.com/css2?family=Vazir&display=swap');

body {
  font-family: 'Vazir', sans-serif;
  background: #f4f7fb;
  color: #333;
  margin: 0;
  padding: 0;
}

h2 {
  text-align: center;
  color: #1a237e;
  margin-top: 30px;
  font-size: 28px;
}

form {
  background: #fff;
  max-width: 900px;
  margin: 30px auto;
  padding: 40px 50px;
  border-radius: 20px;
  box-shadow: 0 8px 20px rgba(0,0,0,0.1);
  direction: rtl;
}

label {
  font-weight: bold;
  color: #1a237e;
  display: block;
  margin-bottom: 8px;
}

input[type="text"],
input[type="file"],
textarea {
  width: 100%;
  padding: 10px 15px;
  margin-bottom: 20px;
  border: 1px solid #ccd1e4;
  border-radius: 10px;
  font-size: 15px;
  transition: 0.2s;
}

input:focus,
textarea:focus {
  border-color: #1a73e8;
  box-shadow: 0 0 5px rgba(26, 115, 232, 0.3);
  outline: none;
}

button {
  background: linear-gradient(90deg, #1a73e8, #0c47b7);
  color: #fff;
  border: none;
  padding: 14px 35px;
  border-radius: 30px;
  font-size: 16px;
  cursor: pointer;
  transition: 0.3s;
}

button:hover {
  background: linear-gradient(90deg, #0c47b7, #1a237e);
}

.alert {
  max-width: 900px;
  margin: 20px auto;
  padding: 15px 25px;
  border-radius: 10px;
  text-align: center;
  font-weight: bold;
}

.alert.success {
  background: #d7ffd9;
  color: #1b5e20;
  border: 1px solid #81c784;
}

.alert.error {
  background: #ffe0e0;
  color: #b71c1c;
  border: 1px solid #ef9a9a;
}

img {
  display: block;
  margin-top: 10px;
  border-radius: 15px;
  max-width: 250px;
  box-shadow: 0 4px 10px rgba(0,0,0,0.15);
}
</style>
<h2>Add New Slide</h2>
<link rel="stylesheet" href="../assets/css/style.css">

<form method="post" enctype="multipart/form-data">
    Type:
    <select name="type">
        <option value="image">Image</option>
        <option value="video">Video</option>
    </select><br><br>

    Title:<br>
    <input type="text" name="title" required><br><br>

    Caption:<br>
    <textarea name="caption" id="caption" rows="5" cols="60"></textarea><br><br>

    Position: <input type="number" name="position" value="1" required><br><br>

    File: <input type="file" name="file" required><br><br>

    <button type="submit">Add Slide</button>
</form>
<textarea id="caption" name="caption"></textarea>

<script src="https://cdn.tiny.cloud/1/2nyevjbzoe9s0cqpit8eqinyyajkxjhanploe5k3zux76aq2/tinymce/7/tinymce.min.js" referrerpolicy="origin"></script>

<script>
tinymce.init({
  selector: '#caption',
  height: 300,
  plugins: 'advlist autolink lists link image charmap preview anchor searchreplace code fullscreen insertdatetime media table help wordcount',
  toolbar: 'undo redo | blocks | bold italic underline | alignleft aligncenter alignright | bullist numlist | link image media | removeformat | code',
  setup: (editor) => {
    editor.on('change', () => editor.save()); // ensures content is saved in textarea
  }
});
</script>


</body>
</html>
