<?php include '../includes/auth.php'; ?>
<?php include '../includes/header.php'; ?>
<?php include '../includes/db.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Dashboard</title>
<style>
body {
    font-family: "Segoe UI", sans-serif;
    background: #f3f5f9;
    margin: 0;
    padding: 0;
}

.dashboard-container {
    width: 90%;
    max-width: 1100px;
    margin: 40px auto;
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(230px, 1fr));
    gap: 25px;
}

.dashboard-card {
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 3px 15px rgba(0,0,0,0.1);
    padding: 30px 20px;
    text-align: center;
    transition: 0.3s;
}

.dashboard-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 6px 20px rgba(0,0,0,0.15);
}

.dashboard-card h3 {
    color: #1a237e;
    margin-bottom: 10px;
    font-size: 1.4rem;
}

.dashboard-card p {
    color: #555;
    margin-bottom: 20px;
}

.dashboard-card a {
    display: inline-block;
    background: #007bff;
    color: white;
    padding: 10px 15px;
    border-radius: 6px;
    text-decoration: none;
    font-weight: 600;
    transition: 0.3s;
}

.dashboard-card a:hover {
    background: #0056b3;
}
</style>
</head>

<body>

<div class="dashboard-container">
    <div class="dashboard-card">
        <h3>📰 News</h3>
        <p>Manage latest news and updates.</p>
        <a href="News_php.php">Add News</a>
    </div>

    <div class="dashboard-card">
        <h3>📝 Blogs</h3>
        <p>Write, edit, and manage blog posts.</p>
        <a href="blog_add.php">Add Blog</a>
    </div>

    <div class="dashboard-card">
        <h3>🏥 Departments</h3>
        <p>Manage departments and their details.</p>
        <a href="DepartementsAdd.php">Add Department</a>
    </div>

    <div class="dashboard-card">
        <h3>⚙️ Services</h3>
        <p>Add or update service details.</p>
        <a href="manage_services.php">Add Service</a>
    </div>

    <div class="dashboard-card">
        <h3>🎯 Careers</h3>
        <p>Manage job postings and careers.</p>
        <a href="addjobs.php">Manage Careers</a>
    </div>

    <div class="dashboard-card">
        <h3>📦 View All Data</h3>
        <p>Quick access to all lists.</p>
        <a href="manage_services.php">View All</a>
    </div>

    <div class="dashboard-card">
    <h3>👥 Applicants</h3>
    <p>View people who applied for jobs.</p>
    <a href="view_applications.php">View Applicants</a>
</div>

</div>




<?php include '../includes/footer.php'; ?>
</body>
</html>
