<?php 
include '../includes/auth.php'; 
include '../includes/db.php'; 
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
</head>
<body>
<div class="admin-container">
    <h2>Add Blog Post</h2>

    <?php
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $title = mysqli_real_escape_string($conn, $_POST['title']);
        $content = mysqli_real_escape_string($conn, $_POST['content']);
        $author = mysqli_real_escape_string($conn, $_POST['author']);

        $imagePath = null;
        if (!empty($_FILES['image']['name'])) {
            $targetDir = "../uploads/blog/";
            if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);

            $fileName = time() . '_' . basename($_FILES["image"]["name"]);
            $targetFile = $targetDir . $fileName;

            if (move_uploaded_file($_FILES["image"]["tmp_name"], $targetFile)) {
                $imagePath = "uploads/blog/" . $fileName;
            }
        }

        $sql = "INSERT INTO blog (title, content, image, author) VALUES ('$title', '$content', '$imagePath', '$author')";
        if ($conn->query($sql)) {
            echo "<p class='success'>✅ Blog post added successfully!</p>";
        } else {
            echo "<p class='error'>❌ Error: " . $conn->error . "</p>";
        }
    }
    ?>

    <form method="POST" enctype="multipart/form-data" class="news-form">
        <label for="title">Blog Title:</label>
        <input type="text" name="title" id="title" required>

        <label for="author">Author:</label>
        <input type="text" name="author" id="author">

        <label for="image">Featured Image:</label>
        <input type="file" name="image" id="image" accept="image/*">

        <label for="content">Content:</label>
        <textarea name="content" id="content" style="width:100%; height:300px;"></textarea>

        <button type="submit" class="btn">Add Blog Post</button>
    </form>
</div>

<!-- TinyMCE -->
<script src="https://cdn.tiny.cloud/1/2nyevjbzoe9s0cqpit8eqinyyajkxjhanploe5k3zux76aq2/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
<script>
tinymce.init({
    selector: '#content',
    height: 400,
    plugins: 'advlist anchor autolink autocompleter autosave bbcode casechange charmap codesample colorpicker contextmenu directionality emoticons fullscreen help hr image importcss insertdatetime link lists media nonbreaking pagebreak paste preview print save searchreplace spellchecker table template textpattern toc visualblocks wordcount',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | forecolor backcolor | link image media emoticons | alignleft aligncenter alignright alignjustify | bullist numlist checklist | outdent indent | blockquote removeformat | pagebreak | table | charmap codesample | insertdatetime | preview print | fullscreen',
    menubar: 'file edit view insert format tools table help',
    toolbar_mode: 'wrap',
    branding: false
});
</script>

<style>
.admin-container {
    width:80%; margin:40px auto; background:#fff; padding:30px 40px; border-radius:10px; box-shadow:0 4px 20px rgba(0,0,0,0.1);
}
.admin-container h2 { text-align:center; margin-bottom:25px; color:#333; font-size:1.8rem; }
.news-form { display:flex; flex-direction:column; gap:15px; }
.news-form label { font-weight:bold; color:#444; }
.news-form input[type="text"], .news-form input[type="file"], .news-form textarea { padding:10px; border:1px solid #ccc; border-radius:8px; font-size:1rem; width:100%; }
.btn { width:200px; background:#007bff; color:white; padding:10px 15px; border:none; border-radius:6px; cursor:pointer; font-weight:bold; transition:0.3s; align-self:center; }
.btn:hover { background:#0056b3; }
.success { background:#d4edda; color:#155724; padding:10px; border-radius:6px; text-align:center; }
.error { background:#f8d7da; color:#721c24; padding:10px; border-radius:6px; text-align:center; }
</style>

</body>
</html>
