<?php
include '../includes/auth.php';
include '../includes/db.php';
include '../includes/header.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Job Applications</title>
<style>
body {
    font-family: "Segoe UI", sans-serif;
    background: #f3f5f9;
    margin: 0;
    padding: 0;
}
.container {
    width: 90%;
    max-width: 1200px;
    margin: 40px auto;
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 3px 10px rgba(0,0,0,0.1);
    padding: 25px;
}
h2 {
    color: #1a237e;
    text-align: center;
    margin-bottom: 30px;
}
table {
    width: 100%;
    border-collapse: collapse;
}
th, td {
    padding: 12px 10px;
    border-bottom: 1px solid #ddd;
    text-align: left;
}
th {
    background: #1a237e;
    color: white;
}
tr:hover {
    background: #f1f1f1;
}
a.view-resume {
    color: #007bff;
    text-decoration: none;
    font-weight: 600;
}
a.view-resume:hover {
    text-decoration: underline;
}
.btn-delete {
    color: #fff;
    background: #dc3545;
    padding: 6px 12px;
    border-radius: 5px;
    text-decoration: none;
}
.btn-delete:hover {
    background: #b52a37;
}
</style>
</head>
<body>

<div class="container">
    <h2>📂 Job Applications</h2>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Job Title</th>
                <th>Full Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Message</th>
                <th>Resume</th>
                <th>Applied At</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
        <?php
        $sql = "SELECT a.*, j.title AS job_title 
                FROM job_applications a 
                JOIN jobs j ON a.job_id = j.id 
                ORDER BY a.applied_at DESC";
        $result = $conn->query($sql);

        if ($result && $result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                echo "<tr>
                    <td>{$row['id']}</td>
                    <td>{$row['job_title']}</td>
                    <td>{$row['full_name']}</td>
                    <td>{$row['email']}</td>
                    <td>{$row['phone']}</td>
                    <td>".htmlspecialchars(substr($row['message'], 0, 60))."...</td>
                    <td><a class='view-resume' href='../uploads/{$row['resume']}' target='_blank'>View CV</a></td>
                    <td>{$row['applied_at']}</td>
                    <td><a class='btn-delete' href='delete_application.php?id={$row['id']}' onclick='return confirm(\"Delete this application?\")'>Delete</a></td>
                </tr>";
            }
        } else {
            echo "<tr><td colspan='9' style='text-align:center;'>No applications found</td></tr>";
        }
        ?>
        </tbody>
    </table>
</div>

<?php include '../includes/footer.php'; ?>
</body>
</html>
