<?php
include '../includes/auth.php';
include '../includes/db.php';
include '../includes/header.php';
?>

<div style="
    width: 90%;
    max-width: 1100px;
    margin: 40px auto;
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 3px 15px rgba(0,0,0,0.1);
    padding: 25px;
">
    <h3 style="color:#1a237e; margin-bottom: 20px;">📄 Latest Job Applicants</h3>

    <table style="width:100%; border-collapse:collapse;">
        <thead>
            <tr style="background:#1a237e; color:white;">
                <th style="padding:12px;">Name</th>
                <th style="padding:12px;">Job Title</th>
                <th style="padding:12px;">Applied At</th>
                <th style="padding:12px;">CV</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $sql = "SELECT a.full_name, a.applied_at, a.resume, j.title AS job_title
                    FROM job_applications a
                    JOIN jobs j ON a.job_id = j.id
                    ORDER BY a.applied_at DESC
                    LIMIT 5";
            $result = $conn->query($sql);

            if ($result && $result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    echo "
                    <tr style='border-bottom:1px solid #ddd;'>
                        <td style=\"padding:12px;\">{$row['full_name']}</td>
                        <td style=\"padding:12px;\">{$row['job_title']}</td>
                        <td style=\"padding:12px;\">{$row['applied_at']}</td>
                        <td style=\"padding:12px;\">
                            <a href=\"../uploads/{$row['resume']}\" target=\"_blank\" 
                               style=\"color:#007bff; font-weight:600;\">Open CV</a>
                        </td>
                    </tr>";
                }
            } else {
                echo "<tr><td colspan='4' style='padding:15px; text-align:center;'>No applications yet</td></tr>";
            }
            ?>
        </tbody>
    </table>

    <div style="text-align:right; margin-top:15px;">
        <a href='view_applications.php' 
           style="background:#007bff; color:white; padding:10px 14px; 
                  border-radius:6px; text-decoration:none; font-weight:600;">
            View All Applications →
        </a>
    </div>
</div>
