  <style type="text/css">
  /* ---------- HEADER + NAV ---------- */
  .main-header {
    width: 100%;
    background: linear-gradient(90deg, #004aad, #0078d7);
    color: white;
    padding: 10px 0;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    position: sticky;
    top: 0;
    z-index: 1000;
  }

  .main-header .container {
    display: flex;
    align-items: center;
    justify-content: space-between;
    max-width: 1300px;
    margin: 0 auto;
    padding: 0 20px;
  }

  .logo {
    display: flex;
    align-items: center;
    font-size: 1.4em;
    font-weight: bold;
  }

  .logo img {
    width: 45px;
    height: 45px;
    margin-right: 10px;
    border-radius: 50%;
    background: white;
    padding: 3px;
  }

  .navbar {
    flex: 1;
    text-align: center;
  }

  .nav-links {
    list-style: none;
    display: flex;
    justify-content: center;
    gap: 25px;
    margin: 0;
    padding: 0;
  }

  .nav-links li {
    position: relative;
  }

  .nav-links a {
    text-decoration: none;
    color: white;
    font-weight: 500;
    transition: color 0.3s;
  }

  .nav-links a:hover {
    color: #ffdd57;
  }

  /* Dropdown */
  .dropdown-menu {
    position: absolute;
    top: 35px;
    left: 0;
    background: white;
    color: #333;
    display: none;
    flex-direction: column;
    box-shadow: 0 4px 10px rgba(0,0,0,0.1);
    border-radius: 6px;
    min-width: 180px;
  }

  .dropdown-menu li a {
    color: #333;
    padding: 10px 15px;
    display: block;
  }

  .dropdown-menu li a:hover {
    background: #f2f2f2;
  }

  .dropdown:hover .dropdown-menu {
    display: flex;
  }

  /* Search box */
  .search-box {
    margin-left: 15px;
    position: relative;
  }

  .search-box input {
    border: none;
    padding: 7px 12px;
    border-radius: 20px;
    outline: none;
    font-size: 14px;
    width: 160px;
    transition: width 0.3s;
  }

  .search-box input:focus {
    width: 220px;
  }

  #search-results {
    position: absolute;
    top: 40px;
    left: 0;
    background: white;
    color: #333;
    border: 1px solid #ccc;
    border-radius: 6px;
    display: none;
    max-height: 300px;
    overflow-y: auto;
    width: 240px;
    z-index: 1001;
    box-shadow: 0 4px 10px rgba(0,0,0,0.15);
  }

  #search-results ul {
    list-style: none;
    margin: 0;
    padding: 0;
  }

  #search-results li {
    padding: 10px;
    border-bottom: 1px solid #eee;
    cursor: pointer;
  }

  #search-results li:hover {
    background: #f2f2f2;
  }

  /* Mobile Menu */
  .menu-toggle {
    display: none;
    cursor: pointer;
    font-size: 26px;
  }

  @media (max-width: 900px) {
    .nav-links {
      flex-direction: column;
      background: #0058c0;
      position: absolute;
      top: 65px;
      left: 0;
      width: 100%;
      text-align: left;
      display: none;
    }

    .navbar.active .nav-links {
      display: flex;
    }

    .menu-toggle {
      display: block;
    }

    .search-box {
      display: none;
    }
  }
  </style>

  <header class="main-header">
    <div class="container">
      <div class="logo">
        <img src="logo.png" alt="Lab Logo">
        <span>Sigal Laboratories</span>
      </div>

      <nav class="navbar" id="navbar">
        <ul class="nav-links">
          <li><a href="./index.php">Home</a></li>
          <li><a href="../public/about.php">About Us</a></li>
          <li><a href="#">Test Catalog</a></li>
          <li><a href="career.php">Career</a></li>
          <li><a href="Allnews.php">News</a></li>
          <li><a href="Allblogs.php">Blog</a></li>
          <li><a href="Alldepartements.php">Departments</a></li>
          <li class="dropdown">
            <a href="#">Publications ▾</a>
            <ul class="dropdown-menu">
              <li><a href="#">Research</a></li>
              <li><a href="#">White Papers</a></li>
              <li><a href="#">Reports</a></li>
            </ul>
          </li>
          <li><a href="#">Appointment</a></li>
        </ul>
      </nav>

      <div class="search-box">
        <input type="text" id="service-search" placeholder="🔍 Search...">
        <div id="search-results"></div>
      </div>

      <!-- Dashboard Button -->
<a href="Dashboard/index.php" class="dashboard-btn">Dashboard</a>


      <div class="menu-toggle" id="mobile-menu">☰</div>
    </div>
  </header>

  <script>
    // Toggle mobile nav
    const mobileMenu = document.getElementById('mobile-menu');
    const navbar = document.getElementById('navbar');
    mobileMenu.onclick = () => navbar.classList.toggle('active');

    // Live search logic
    const searchInput = document.getElementById('service-search');
    const resultsDiv = document.getElementById('search-results');

    searchInput.addEventListener('input', function() {
      let query = this.value.trim();
      if (query.length === 0) {
        resultsDiv.style.display = 'none';
        resultsDiv.innerHTML = '';
        return;
      }

      fetch('./dashboard/search_services.php?q=' + encodeURIComponent(query))
        .then(response => response.text())
        .then(data => {
          resultsDiv.innerHTML = data;
          resultsDiv.style.display = 'block';
        })
        .catch(err => console.error('Search error:', err));
    });

    // Hide when clicking outside
    document.addEventListener('click', function(e) {
      if (!searchInput.contains(e.target) && !resultsDiv.contains(e.target)) {
        resultsDiv.style.display = 'none';
      }
    });
  </script>



<style type="text/css">
  /* Dashboard Button */
.dashboard-btn {
  background: linear-gradient(90deg, #ffcc00, #ff9900);
  color: #000;
  font-weight: bold;
  padding: 8px 18px;
  border-radius: 25px;
  text-decoration: none;
  transition: all 0.3s ease;
  margin-left: 15px;
  box-shadow: 0 2px 6px rgba(0,0,0,0.2);
}

.dashboard-btn:hover {
  background: linear-gradient(90deg, #ffb300, #ff8000);
  transform: translateY(-2px);
}

</style>