<?php
include 'includes/db.php';

// Check if job ID is provided
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

$job = null;
if ($id > 0) {
  $result = $conn->query("SELECT * FROM jobs WHERE id=$id");
  if ($result && $result->num_rows > 0) {
    $job = $result->fetch_assoc();
  }
}

if (!$job) {
  die("<h2 style='text-align:center;color:red;'>Invalid job selection or job not found.</h2>");
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
  $full_name = trim($_POST['full_name']);
  $email = trim($_POST['email']);
  $phone = trim($_POST['phone']);
  $message = trim($_POST['message']);
  $resume = '';

  // Handle resume upload
  if (!empty($_FILES['resume']['name'])) {
    $targetDir = "uploads/resumes/";
    if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);
    $fileName = time() . "_" . basename($_FILES['resume']['name']);
    $resume = $targetDir . $fileName;
    move_uploaded_file($_FILES['resume']['tmp_name'], $resume);
  }

  // Insert application
  $stmt = $conn->prepare("INSERT INTO job_applications (job_id, full_name, email, phone, resume, message) VALUES (?,?,?,?,?,?)");
  $stmt->bind_param("isssss", $id, $full_name, $email, $phone, $resume, $message);
  $stmt->execute();

  $success = "Your application has been submitted successfully!";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Apply for <?= htmlspecialchars($job['title']) ?> | Sigal Laboratories</title>
<style>
body {
  font-family: 'Segoe UI', Tahoma, sans-serif;
  background: #f4f6f8;
  margin: 0;
  padding: 0;
}
h2 {
  text-align: center;
  color: #004aad;
  margin-top: 40px;
}
form {
  max-width: 600px;
  margin: 40px auto;
  background: #fff;
  padding: 25px;
  border-radius: 10px;
  box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}
input, textarea {
  width: 100%;
  margin: 10px 0;
  padding: 10px;
  border-radius: 6px;
  border: 1px solid #ccc;
  font-size: 15px;
}
label {
  font-weight: bold;
  color: #333;
  margin-top: 10px;
  display: block;
}
button {
  background: #004aad;
  color: white;
  border: none;
  padding: 10px 20px;
  border-radius: 6px;
  cursor: pointer;
  font-size: 16px;
  transition: background 0.3s;
}
button:hover {
  background: #0078d7;
}
.success {
  color: green;
  margin-top: 10px;
  text-align: center;
  font-weight: 600;
}
</style>
</head>
<body>

<h2>Apply for: <?= htmlspecialchars($job['title']) ?></h2>

<form method="POST" enctype="multipart/form-data">
  <input type="text" name="full_name" placeholder="Full Name" required>
  <input type="email" name="email" placeholder="Email Address" required>
  <input type="text" name="phone" placeholder="Phone Number" required>
  <textarea name="message" placeholder="Message (optional)" rows="4"></textarea>
  
  <label>Resume (PDF / DOC / DOCX):</label>
  <input type="file" name="resume" accept=".pdf,.doc,.docx">

  <button type="submit">Submit Application</button>

  <?php if(isset($success)) echo "<p class='success'>$success</p>"; ?>
</form>

</body>
</html>
