<?php 
include 'includes/header.php'; 
include 'includes/db.php'; 

$id = intval($_GET['id']);

// Get blog data
$blog = $conn->query("SELECT * FROM blog WHERE id=$id")->fetch_assoc();

// Get all images
$images = $conn->query("SELECT * FROM blog_images WHERE blog_id=$id ORDER BY id ASC");
?>

<section class="blog-details-section">
    <div class="blog-details-container">
        <h1><?= htmlspecialchars($blog['title']) ?></h1>

        <?php if($images->num_rows > 0): ?>
        <div class="blog-slider">
            <div class="slides">
                <?php while($img = $images->fetch_assoc()): ?>
                    <div class="slide">
                        <img src="<?= $img['image_path'] ?>" alt="<?= htmlspecialchars($blog['title']) ?>">
                    </div>
                <?php endwhile; ?>
            </div>
            <button class="prev">&#10094;</button>
            <button class="next">&#10095;</button>
        </div>
        <?php endif; ?>

        <div class="blog-content">
            <?= $blog['content'] ?>
        </div>

        <a href="AllBlogs.php" class="back-btn">← Back to Blogs</a>
    </div>
</section>

<style>
.blog-details-section {
    width: 85%;
    margin: 60px auto;
    font-family: 'Segoe UI', sans-serif;
}

.blog-details-container h1 {
    color: #1a237e;
    margin-bottom: 30px;
}

.blog-slider {
    position: relative;
    overflow: hidden;
    border-radius: 15px;
    margin-bottom: 30px;
}

.slides {
    display: flex;
    transition: transform 0.5s ease-in-out;
}

.slide img {
    width: 100%;
    max-height: 500px;
    object-fit: cover;
    border-radius: 10px;
}

.prev, .next {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    background: rgba(0,0,0,0.5);
    color: white;
    font-size: 2rem;
    padding: 8px 12px;
    cursor: pointer;
    border-radius: 6px;
    user-select: none;
}

.prev { left: 10px; }
.next { right: 10px; }

.blog-content {
    font-size: 1rem;
    color: #333;
    line-height: 1.8;
    margin-bottom: 30px;
}

.back-btn {
    display: inline-block;
    background: #007bff;
    color: #fff;
    padding: 10px 20px;
    border-radius: 6px;
    text-decoration: none;
    transition: 0.3s;
}

.back-btn:hover {
    background: #0056b3;
}
</style>

<script>
// Slider JS
let index = 0;
const slides = document.querySelector('.slides');
const total = document.querySelectorAll('.slide').length;

function showSlide(i) {
    slides.style.transform = `translateX(-${i * 100}%)`;
}

document.querySelector('.next')?.addEventListener('click', () => {
    index = (index + 1) % total;
    showSlide(index);
});

document.querySelector('.prev')?.addEventListener('click', () => {
    index = (index - 1 + total) % total;
    showSlide(index);
});

// Auto-play
setInterval(() => {
    if(total > 1){
        index = (index + 1) % total;
        showSlide(index);
    }
}, 5000);
</script>

<?php include 'includes/footer.php'; ?>
