<?php
include 'includes/db.php';
$result = $conn->query("SELECT * FROM jobs WHERE status='open' ORDER BY created_at DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Career Opportunities | Sigal Laboratories</title>
<link rel="stylesheet" href="assets/css/style.css">
<style>
.container {
  max-width: 1000px;
  margin: 40px auto;
  padding: 0 20px;
  font-family: 'Segoe UI', Tahoma, sans-serif;
}
h2 {
  color: #004aad;
  text-align: center;
  margin-bottom: 30px;
}
.job-card {
  background: #fff;
  border-radius: 10px;
  padding: 20px;
  margin: 15px 0;
  box-shadow: 0 2px 10px rgba(0,0,0,0.1);
  transition: transform 0.2s ease, box-shadow 0.2s ease;
}
.job-card:hover {
  transform: translateY(-3px);
  box-shadow: 0 4px 16px rgba(0,0,0,0.15);
}
.job-card h3 { 
  color: #004aad; 
  margin-bottom: 10px; 
}
.job-card p { 
  color: #333; 
  line-height: 1.6; 
}
.apply-btn {
  display: inline-block;
  background: linear-gradient(90deg, #0078d7, #004aad);
  color: white;
  padding: 10px 20px;
  border-radius: 6px;
  text-decoration: none;
  font-weight: 600;
  margin-top: 10px;
  transition: background 0.3s;
}
.apply-btn:hover { 
  background: linear-gradient(90deg, #005cb9, #003b8e); 
}
.no-jobs {
  text-align: center;
  color: #666;
  background: #f8f9fb;
  padding: 40px;
  border-radius: 8px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}
</style>
</head>
<body>

<?php include 'includes/header.php'; ?>

<div class="container">
  <h2>Current Job Openings</h2>

  <?php if ($result->num_rows > 0): ?>
    <?php while($row = $result->fetch_assoc()): ?>
      <div class="job-card">
        <h3><?= htmlspecialchars($row['title']) ?></h3>
        <p><strong>Department:</strong> <?= htmlspecialchars($row['department']) ?></p>
        <p><?= nl2br(substr($row['description'], 0, 200)) ?>...</p>
        <a href="apply.php?id=<?= $row['id'] ?>" class="apply-btn">Apply Now</a>
      </div>
    <?php endwhile; ?>
  <?php else: ?>
    <div class="no-jobs">
      <h3>No job openings are currently available.</h3>
      <p>Please check back later for new opportunities at Sigal Laboratories.</p>
    </div>
  <?php endif; ?>
</div>

</body>
</html>
