<?php 
include 'includes/header.php'; 
include 'includes/db.php'; 

$id = intval($_GET['id']);

// Get department data
$deptResult = $conn->query("SELECT * FROM departments WHERE id=$id");
if(!$deptResult || $deptResult->num_rows === 0){
    echo "<p style='text-align:center; color:red;'>Department not found.</p>";
    exit;
}
$dept = $deptResult->fetch_assoc();

// Get all department images
$imagesResult = $conn->query("SELECT * FROM department_images WHERE department_id=$id ORDER BY id ASC");
$images = [];
if($imagesResult && $imagesResult->num_rows > 0){
    while($img = $imagesResult->fetch_assoc()){
        $images[] = $img['image_path'];
    }
} else {
    $images[] = 'assets/images/no-image.jpg';
}
?>

<section class="department-details-section">
    <div class="department-details-container">
        <h1><?= htmlspecialchars($dept['name']); ?></h1>

        <?php if(count($images) > 0): ?>
        <div class="department-slider">
            <div class="slides">
                <?php foreach($images as $imgPath): ?>
                    <div class="slide">
                        <img src="<?= htmlspecialchars($imgPath) ?>" alt="<?= htmlspecialchars($dept['name']); ?>">
                    </div>
                <?php endforeach; ?>
            </div>
            <?php if(count($images) > 1): ?>
            <button class="prev">&#10094;</button>
            <button class="next">&#10095;</button>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <div class="department-content">
            <?= nl2br($dept['description']); ?>
        </div>

        <a href="departments.php" class="back-btn">← Back to Departments</a>
    </div>
</section>

<style>
.department-details-section {
    width: 85%;
    margin: 60px auto;
    font-family: 'Segoe UI', sans-serif;
}

.department-details-container h1 {
    color: #1a237e;
    margin-bottom: 30px;
}

.department-slider {
    position: relative;
    overflow: hidden;
    border-radius: 15px;
    margin-bottom: 30px;
}

.slides {
    display: flex;
    transition: transform 0.5s ease-in-out;
}

.slide img {
    width: 100%;
    max-height: 500px;
    object-fit: cover;
    border-radius: 10px;
}

.prev, .next {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    background: rgba(0,0,0,0.5);
    color: white;
    font-size: 2rem;
    padding: 8px 12px;
    cursor: pointer;
    border-radius: 6px;
    user-select: none;
}

.prev { left: 10px; }
.next { right: 10px; }

.department-content {
    font-size: 1rem;
    color: #333;
    line-height: 1.8;
    margin-bottom: 30px;
}

.back-btn {
    display: inline-block;
    background: #007bff;
    color: #fff;
    padding: 10px 20px;
    border-radius: 6px;
    text-decoration: none;
    transition: 0.3s;
}

.back-btn:hover {
    background: #0056b3;
}
</style>

<script>
// Slider JS
let index = 0;
const slides = document.querySelector('.department-slider .slides');
const total = document.querySelectorAll('.department-slider .slide').length;

function showSlide(i) {
    slides.style.transform = `translateX(-${i * 100}%)`;
}

document.querySelector('.department-slider .next')?.addEventListener('click', () => {
    index = (index + 1) % total;
    showSlide(index);
});

document.querySelector('.department-slider .prev')?.addEventListener('click', () => {
    index = (index - 1 + total) % total;
    showSlide(index);
});

// Auto-play every 5 seconds
setInterval(() => {
    if(total > 1){
        index = (index + 1) % total;
        showSlide(index);
    }
}, 5000);
</script>

<?php include 'includes/footer.php'; ?>
