<?php include 'includes/header.php'; ?>
<?php include 'includes/db.php'; ?>


<div class="slider section-fade">
<div class="slider">
  <!-- your slider code here -->
<!-- MAIN  -->
<div class="slider">
    <div class="slides">
        <link rel="stylesheet" href="assets/css/slider/style.css">
        <?php
        $result = $conn->query("SELECT * FROM slider ORDER BY position ASC");
        while ($row = $result->fetch_assoc()):
        ?>
            <div class="slide">
                <?php if ($row['type'] == 'image'): ?>
                    <img src="<?php echo $row['file_path']; ?>" alt="<?php echo $row['title']; ?>">
                <?php else: ?>
                    <video autoplay muted loop>
                        <source src="<?php echo $row['file_path']; ?>" type="video/mp4">
                    </video>
                <?php endif; ?>

                <div class="caption">
                    <h2><?php echo $row['title']; ?></h2>
                    <div class="caption-text"><?php echo $row['caption']; ?></div>
                </div>
            </div>
        <?php endwhile; ?>
    </div>

    <button class="prev">&#10094;</button>
    <button class="next">&#10095;</button>
</div>
</div>

</div>



<div style="width: 80%; height: 2px; background: #1a237e; margin: 50px auto; border-radius: 5px;"></div>



<!-- NEWS SECTION -->
<style>
.news-section {
    padding: 60px 0;
    background: #f8f9fa;
    text-align: center;
}

.section-title {
    font-size: 2rem;
    margin-bottom: 40px;
    font-weight: 700;
    color: #333;
}

.news-container {
    display: flex;
    justify-content: center;
    gap: 20px;
    flex-wrap: wrap;
}

.news-card {
    position: relative;
    width: 320px;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 4px 15px rgba(0,0,0,0.2);
    transition: transform 0.3s;
    background: #000; /* fallback */
}

.news-card:hover {
    transform: scale(1.03);
}

.news-slider {
    position: relative;
    width: 100%;
    height: 180px;
    overflow: hidden;
}

.news-slider .slides-inner {
    display: flex;
    transition: transform 0.4s ease;
}

.news-slider img {
    width: 100%;
    height: 180px;
    object-fit: cover;
}

.news-slider .slider-nav {
    position: absolute;
    top: 50%;
    width: 100%;
    display: flex;
    justify-content: space-between;
    transform: translateY(-50%);
}

.news-slider .slider-nav button {
    background: rgba(0,0,0,0.4);
    border: none;
    color: #fff;
    font-size: 1.2rem;
    padding: 4px 10px;
    cursor: pointer;
    border-radius: 5px;
}

.news-content {
    padding: 15px;
    text-align: left;
    background: #fff;
}

.news-content h3 {
    font-size: 1.2rem;
    margin-bottom: 8px;
    color: #1a237e;
}

.news-content p {
    font-size: 0.95rem;
    line-height: 1.4;
    height: 40px;
    overflow: hidden;
    margin-bottom: 10px;
}

.see-more {
    display: inline-block;
    background: #ff6600;
    color: white;
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 0.85rem;
    text-decoration: none;
}

.see-more:hover {
    background: #ff8533;
}

.no-news {
    color: #555;
    font-size: 1rem;
}
</style>
<section class="news-section section-fade">
<h2 class="section-title">Latest News</h2>
    <div class="news-container">
        <?php
        $query = "SELECT * FROM news ORDER BY created_at DESC LIMIT 3";
        $result = $conn->query($query);

        if ($result->num_rows > 0):
            while ($row = $result->fetch_assoc()):
                $newsId = $row['id'];
                $imgResult = $conn->query("SELECT image_path FROM news_images WHERE news_id=$newsId");
                $images = [];
                if ($imgResult->num_rows > 0) {
                    while($imgRow = $imgResult->fetch_assoc()){
                        $images[] = $imgRow['image_path'];
                    }
                } elseif (!empty($row['image'])) {
                    $images[] = $row['image'];
                } else {
                    $images[] = 'assets/images/no-image.jpg';
                }
        ?>
            <div class="news-card">
                <div class="news-slider" id="news-slider-<?= $newsId ?>">
                    <div class="slides-inner">
                        <?php foreach($images as $imgPath): ?>
                            <img src="<?= htmlspecialchars($imgPath) ?>" alt="">
                        <?php endforeach; ?>
                    </div>
                    <?php if(count($images) > 1): ?>
                    <div class="slider-nav">
                        <button class="prev">&lt;</button>
                        <button class="next">&gt;</button>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="news-content">
                    <h3><?= htmlspecialchars($row['title']); ?></h3>
                    <p><?= substr(strip_tags($row['content']),0,120) . '...'; ?></p>
                    <a href="news-details.php?id=<?= $row['id']; ?>" class="see-more">See More →</a>
                </div>
            </div>
        <?php
            endwhile;
        else:
            echo "<p class='no-news'>No news available.</p>";
        endif;
        ?>
    </div>
</section>











<div style="width: 80%; height: 2px; background: #1a237e; margin: 50px auto; border-radius: 5px;"></div>
<!-- BLOG SECTION -->
<section class="blog-section section-fade">
    <h2 class="section-title">Latest Blogs</h2>
    <div class="blog-container">
        <?php
        $blogs = $conn->query("SELECT * FROM blog ORDER BY created_at DESC LIMIT 3");
        if($blogs->num_rows > 0):
            while($blog = $blogs->fetch_assoc()):
                $blogId = $blog['id'];
                $imgResult = $conn->query("SELECT image_path FROM blog_images WHERE blog_id=$blogId ORDER BY id ASC");
                $images = [];
                if($imgResult->num_rows > 0){
                    while($imgRow = $imgResult->fetch_assoc()){
                        $images[] = $imgRow['image_path'];
                    }
                } else {
                    $images[] = 'assets/images/default.jpg';
                }
        ?>
        <div class="blog-card">
            <div class="blog-slider" id="blog-slider-<?= $blogId ?>">
                <div class="slides-inner">
                    <?php foreach($images as $imgPath): ?>
                        <img src="<?= htmlspecialchars($imgPath) ?>" alt="">
                    <?php endforeach; ?>
                </div>
                <?php if(count($images) > 1): ?>
                <div class="slider-nav">
                    <button class="prev">&lt;</button>
                    <button class="next">&gt;</button>
                </div>
                <?php endif; ?>
            </div>
            <div class="blog-content">
                <h3><?= htmlspecialchars($blog['title']); ?></h3>
                <p><?= substr(strip_tags($blog['content']),0,100).'...'; ?></p>
                <a href="blogdetails.php?id=<?= $blogId ?>" class="read-more">Read More →</a>
            </div>
        </div>
        <?php
            endwhile;
        else:
            echo "<p class='no-blog'>No blogs available.</p>";
        endif;
        ?>
    </div>
</section>

<!-- DEPARTMENTS SECTION -->
<section class="departments-section section-fade">
    <h2 class="section-title">Our Departments</h2>
    <div class="departments-container">
        <?php
        $result = $conn->query("SELECT * FROM departments ORDER BY id DESC LIMIT 3");
        if($result->num_rows > 0):
            while($dept = $result->fetch_assoc()):
                $deptId = $dept['id'];
                $imgResult = $conn->query("SELECT image_path FROM department_images WHERE department_id=$deptId ORDER BY id ASC");
                $images = [];
                if($imgResult->num_rows > 0){
                    while($imgRow = $imgResult->fetch_assoc()){
                        $images[] = $imgRow['image_path'];
                    }
                } else {
                    $images[] = 'assets/images/no-image.jpg';
                }
                $shortDesc = substr(strip_tags($dept['description']),0,100) . '...';
        ?>
        <div class="department-card">
            <div class="department-slider" id="dept-slider-<?= $deptId ?>">
                <div class="slides-inner">
                    <?php foreach($images as $imgPath): ?>
                        <img src="<?= htmlspecialchars($imgPath) ?>" alt="">
                    <?php endforeach; ?>
                </div>
                <?php if(count($images) > 1): ?>
                <div class="slider-nav">
                    <button class="prev">&lt;</button>
                    <button class="next">&gt;</button>
                </div>
                <?php endif; ?>
            </div>
            <div class="department-content">
                <h3><?= htmlspecialchars($dept['name']) ?></h3>
                <p><?= $shortDesc ?></p>
                <a href="departementdetails.php?id=<?= $deptId ?>" class="read-more">Read More →</a>
            </div>
        </div>
        <?php
            endwhile;
        else:
            echo "<p class='no-departments'>No departments available.</p>";
        endif;
        ?>
    </div>
</section>




<style>
.departments-section { background: #f8f9fa; padding: 50px 0; }
.section-title { text-align: center; font-size: 2rem; margin-bottom: 40px; color: #1a237e; }
.departments-container { display: flex; flex-wrap: wrap; gap: 30px; justify-content: center; }
.department-card { background: #fff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.1); width: 280px; overflow: hidden; display: flex; flex-direction: column; }
.department-thumb img { width: 100%; height: 180px; object-fit: cover; }
.department-content { padding: 20px; display: flex; flex-direction: column; gap: 10px; }
.department-content h3 { margin: 0; color: #1a237e; font-size: 1.2rem; }
.department-content p { font-size: 0.95rem; color: #555; }
.read-more { align-self: flex-start; color: #007bff; font-weight: bold; text-decoration: none; }
.read-more:hover { text-decoration: underline; }
.no-departments { text-align: center; color: #777; }

</style>



<style>
.blog-section {
    padding: 60px 0;

    background: #f8f9fa;
    text-align: center;
}

.section-title {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 40px;
    color: #333;
}

.blog-container {
    display: flex;
    justify-content: center;
    flex-wrap: wrap;
    gap: 20px;

}

.blog-card {
    position: relative;
    width: 0px;
    height: 0px;
    border-radius: 15px;
    overflow: hidden;
    background-size: cover;
    background-position: center;
    box-shadow: 0 4px 15px rgba(0,0,0,0.2);
    transition: transform 0.3s;
}

.blog-card:hover {
    transform: scale(1.03);
}

.blog-card .overlay {
    position: absolute;
    inset: 0;
    background: rgba(0,0,0,0.5);
}

.blog-content {
    position: absolute;
    bottom: 0;
    padding: 20px;
    color: #fff;
    text-align: left;
}

.blog-content h3 {
    font-size: 1.2rem;
    margin-bottom: 8px;
}

.blog-content p {
    font-size: 0.9rem;
    line-height: 1.3;
    margin-bottom: 10px;
}

.read-more {
    background: #ff6600;
    color: white;
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 0.85rem;
    text-decoration: none;
}

.read-more:hover {
    background: #ff8533;
}

.no-blog {
    color: #555;
    font-size: 1rem;
}
</style>




<!-- JS Main Slider -->
<script>
let index = 0;
const slides = document.querySelector('.slides');
const total = document.querySelectorAll('.slide').length;

function showSlide(i) {
    slides.style.transform = `translateX(-${i * 100}%)`;
}

document.querySelector('.next').addEventListener('click', () => {
    index = (index + 1) % total;
    showSlide(index);
});

document.querySelector('.prev').addEventListener('click', () => {
    index = (index - 1 + total) % total;
    showSlide(index);
});

// Auto-play
setInterval(() => {
    index = (index + 1) % total;
    showSlide(index);
}, 5000);
</script>

<!-- JS News Card Slider -->
<!-- JS News Card Slider with touch/swipe support -->
<script>
document.querySelectorAll('.news-slider').forEach(slider => {
    const slidesInner = slider.querySelector('.slides-inner');
    const images = slidesInner.querySelectorAll('img');
    let idx = 0;

    const prevBtn = slider.querySelector('.prev');
    const nextBtn = slider.querySelector('.next');

    // Desktop buttons
    if(prevBtn && nextBtn) {
        prevBtn.addEventListener('click', () => {
            idx = (idx - 1 + images.length) % images.length;
            slidesInner.style.transform = `translateX(-${idx * 100}%)`;
        });
        nextBtn.addEventListener('click', () => {
            idx = (idx + 1) % images.length;
            slidesInner.style.transform = `translateX(-${idx * 100}%)`;
        });
    }

    // Touch swipe support
    let startX = 0;
    let endX = 0;

    slidesInner.addEventListener('touchstart', e => {
        startX = e.touches[0].clientX;
    });

    slidesInner.addEventListener('touchmove', e => {
        endX = e.touches[0].clientX;
    });

    slidesInner.addEventListener('touchend', () => {
        const diff = startX - endX;
        if(diff > 30) {
            // swipe left → next
            idx = (idx + 1) % images.length;
        } else if(diff < -30) {
            // swipe right → prev
            idx = (idx - 1 + images.length) % images.length;
        }
        slidesInner.style.transform = `translateX(-${idx * 100}%)`;
    });
});
</script>





<div class="clients-section">
  <h2>Healthcare Institutions and Organizations</h2>
  <div class="clients-wrapper">
    <?php
      $query = "SELECT * FROM clients ORDER BY id DESC";
      $result = $conn->query($query);
      if ($result && $result->num_rows > 0):
          while($row = $result->fetch_assoc()):
    ?>
      <div class="client-box">
        <img src="Dashboard/images/clients/<?php echo htmlspecialchars($row['logo']); ?>" alt="Client Logo">
      </div>
    <?php
          endwhile;
      else:
          echo "<p style='text-align:center;'>No clients available.</p>";
      endif;
    ?>
  </div>
</div>

<style type="text/css">
    .clients-wrapper {
    display: flex;
    flex-wrap: wrap;      /* optional: wrap logos to next line if needed */
    justify-content: center;
    gap: 10px;            /* spacing between logos */
    padding: 10px 0;
}

.client-box {
    height: 80px;         /* fixed height */
    width: auto;          /* width adjusts automatically */
    display: flex;
    justify-content: center;
    align-items: center;
    background: #fff;     /* optional styling */
    border-radius: 8px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
    padding: 5px;
}

.client-box img {
    max-height: 100%;     /* make image fit inside the box */
    width: auto;          /* maintain aspect ratio */
    display: block;
    object-fit: contain;  /* ensures it doesn't stretch */
}

</style>


<?php include 'includes/footer.php'; ?>

<style type="text/css">
    /* Hidden by default */
.section-fade {
    opacity: 0;
    transform: translateY(20px); /* slightly move down */
    transition: opacity 1s ease, transform 1s ease;
}

/* Visible when scrolled into view */
.section-fade.visible {
    opacity: 1;
    transform: translateY(0);
}
</style>

<script>
// Fade-in sections on scroll
const sections = document.querySelectorAll('.section-fade');

function checkSections() {
    const triggerBottom = window.innerHeight * 0.85; // when 85% of viewport

    sections.forEach(section => {
        const sectionTop = section.getBoundingClientRect().top;
        if(sectionTop < triggerBottom){
            section.classList.add('visible');
        }
    });
}

// Run on scroll and on page load
window.addEventListener('scroll', checkSections);
window.addEventListener('load', checkSections);
</script>

<script type="text/javascript">document.querySelectorAll('.blog-slider, .department-slider').forEach(slider => {
    const slidesInner = slider.querySelector('.slides-inner');
    const images = slidesInner.querySelectorAll('img');
    let idx = 0;

    const prevBtn = slider.querySelector('.prev');
    const nextBtn = slider.querySelector('.next');

    if(prevBtn && nextBtn){
        prevBtn.addEventListener('click', () => {
            idx = (idx - 1 + images.length) % images.length;
            slidesInner.style.transform = `translateX(-${idx * 100}%)`;
        });
        nextBtn.addEventListener('click', () => {
            idx = (idx + 1) % images.length;
            slidesInner.style.transform = `translateX(-${idx * 100}%)`;
        });
    }

    // Touch support
    let startX = 0, endX = 0;
    slidesInner.addEventListener('touchstart', e => startX = e.touches[0].clientX);
    slidesInner.addEventListener('touchmove', e => endX = e.touches[0].clientX);
    slidesInner.addEventListener('touchend', () => {
        const diff = startX - endX;
        if(diff > 30) idx = (idx + 1) % images.length;
        else if(diff < -30) idx = (idx - 1 + images.length) % images.length;
        slidesInner.style.transform = `translateX(-${idx * 100}%)`;
    });
});
</script>


<script type="text/javascript">
    document.querySelectorAll('.news-slider, .blog-slider, .department-slider').forEach(slider => {
    const slidesInner = slider.querySelector('.slides-inner');
    const images = slidesInner.querySelectorAll('img');
    let idx = 0;

    const prevBtn = slider.querySelector('.prev');
    const nextBtn = slider.querySelector('.next');

    function updateSlider() {
        slidesInner.style.transform = `translateX(-${idx * 100}%)`;
    }

    // Desktop buttons
    if(prevBtn && nextBtn && images.length > 1){
        prevBtn.addEventListener('click', () => {
            idx = (idx - 1 + images.length) % images.length;
            updateSlider();
        });
        nextBtn.addEventListener('click', () => {
            idx = (idx + 1) % images.length;
            updateSlider();
        });
    }

    // Auto-slide every 5 seconds
    if(images.length > 1){
        setInterval(() => {
            idx = (idx + 1) % images.length;
            updateSlider();
        }, 5000);
    }

    // Touch support
    let startX = 0, endX = 0;
    slidesInner.addEventListener('touchstart', e => startX = e.touches[0].clientX);
    slidesInner.addEventListener('touchmove', e => endX = e.touches[0].clientX);
    slidesInner.addEventListener('touchend', () => {
        const diff = startX - endX;
        if(diff > 30) idx = (idx + 1) % images.length;
        else if(diff < -30) idx = (idx - 1 + images.length) % images.length;
        updateSlider();
    });
});

</script>


<script type="text/javascript">
    // Fade and lift cards on scroll
const cards = document.querySelectorAll('.news-card, .blog-card, .department-card');

function showCards() {
  const trigger = window.innerHeight * 0.9;
  cards.forEach(card => {
    const top = card.getBoundingClientRect().top;
    if (top < trigger) card.classList.add('visible');
  });
}
window.addEventListener('scroll', showCards);
window.addEventListener('load', showCards);
cards.forEach(c => c.classList.add('card-animate'));

</script>




<!-- ===== FINAL OVERRIDE: unify blog cards & make images taller ===== -->
<style>
/* Make sure blog-card behaves like other cards */
.blog-card {
  position: relative !important;
  display: flex !important;
  flex-direction: column !important;
  width: 400px !important;
  height: 150px!important;
  border-radius: 20px !important;
  overflow: hidden !important;
  background: #fff !important;
  box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
  transition: transform 0.3s ease, box-shadow 0.3s ease !important;
  height: auto !important;
}

/* Remove interfering overlay / absolute layout if present */
.blog-card .overlay {
  display: none !important;
}
.blog-content {
  position: static !important;
  padding: 25px !important;
  background: #fff !important;
  color: #333 !important;
  text-align: left !important;
}

/* Slider / Image area — make taller and consistent with news & department */
.blog-slider,
.news-slider,
.department-slider {
  width: 100% !important;
  height: 380px !important;   /* change to desired height */
  overflow: hidden !important;
  position: relative !important;
}

.blog-slider .slides-inner,
.news-slider .slides-inner,
.department-slider .slides-inner {
  display: flex !important;
  transition: transform 0.4s ease !important;
}

/* Make images fill the taller container */
.blog-slider img,
.news-slider img,
.department-slider img,
.slides-inner img {
  width: 100% !important;
  height: 380px !important;   /* match the slider height */
  object-fit: cover !important;
  display: block !important;
  transition: transform 0.4s ease !important;
}

/* Hover scale */
.blog-card:hover img,
.news-card:hover img,
.department-card:hover img {
  transform: scale(1.05) !important;
}

/* Heading / paragraph sizing to match others */
.blog-content h3 {
  font-size: 1.5rem !important;
  font-weight: 700 !important;
  color: #1a237e !important;
  margin-bottom: 12px !important;
}

.blog-content p {
  font-size: 1.05rem !important;
  color: #555 !important;
  line-height: 1.6 !important;
  margin-bottom: 20px !important;
}

/* Button style unify */
.read-more {
  display: inline-block !important;
  background: #ff6600 !important;
  color: white !important;
  padding: 10px 20px !important;
  border-radius: 10px !important;
  font-size: 1rem !important;
  text-decoration: none !important;
  font-weight: 600 !important;
}

/* Responsive */
@media (max-width: 768px) {
  .blog-card, .news-card, .department-card {
    width: 92% !important;
  }
  .blog-slider img,
  .news-slider img,
  .department-slider img {
    height: 240px !important;
  }
}
</style>

