<?php include 'includes/header.php'; ?>
<?php include 'includes/db.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>News Details</title>
<style>
body {
  background: #f9fafc;
  font-family: 'Segoe UI', sans-serif;
}

.news-details {
  width: 80%;
  margin: 60px auto;
  background: #fff;
  border-radius: 12px;
  box-shadow: 0 6px 20px rgba(0,0,0,0.1);
  overflow: hidden;
  padding: 30px;
}

/* Slider Container */
.image-slider {
  position: relative;
  width: 100%;
  height: 450px;
  overflow: hidden;
  border-radius: 10px;
  margin-bottom: 20px;
}

/* Slides Wrapper */
.image-slider .slides {
  display: flex;
  transition: transform 0.5s ease;
  height: 100%;
}

/* Each Slide */
.image-slider .slides img {
  width: 100%;
  height: 100%;
  object-fit: cover;
}

/* Navigation Buttons */
.image-slider button {
  position: absolute;
  top: 50%;
  transform: translateY(-50%);
  background: rgba(0,0,0,0.5);
  color: #fff;
  border: none;
  font-size: 24px;
  padding: 10px;
  border-radius: 50%;
  cursor: pointer;
  transition: 0.3s;
}

.image-slider button:hover {
  background: rgba(0,0,0,0.8);
}

.image-slider .prev { left: 10px; }
.image-slider .next { right: 10px; }

.news-details h1 {
  color: #1a237e;
  margin-bottom: 15px;
  text-align: center;
}

.news-details .content {
  font-size: 1rem;
  color: #333;
  line-height: 1.8;
}

.back-btn {
  display: inline-block;
  margin-top: 20px;
  background: #007bff;
  color: #fff;
  padding: 10px 20px;
  border-radius: 6px;
  text-decoration: none;
  transition: 0.3s;
}

.back-btn:hover {
  background: #0056b3;
}
</style>
</head>
<body>

<?php
$id = intval($_GET['id']);
$news = $conn->query("SELECT * FROM news WHERE id=$id")->fetch_assoc();
$images = $conn->query("SELECT * FROM news_images WHERE news_id=$id");
?>

<div class="news-details">
  <h1><?= htmlspecialchars($news['title']) ?></h1>

  <!-- Image Slider -->
  <div class="image-slider">
    <div class="slides">
      <?php while($img = $images->fetch_assoc()): ?>
        <img src="<?= $img['image_path'] ?>" alt="news image">
      <?php endwhile; ?>
    </div>
    <button class="prev">&#10094;</button>
    <button class="next">&#10095;</button>
  </div>

  <div class="content"><?= $news['content'] ?></div>

  <a href="Allnews.php" class="back-btn">← Back to News Feed</a>
</div>

<script>
let slideIndex = 0;
const slides = document.querySelector('.slides');
const images = document.querySelectorAll('.slides img');
const totalSlides = images.length;

function showSlide(i) {
  slides.style.transform = `translateX(-${i * 100}%)`;
}

document.querySelector('.next').addEventListener('click', () => {
  slideIndex = (slideIndex + 1) % totalSlides;
  showSlide(slideIndex);
});

document.querySelector('.prev').addEventListener('click', () => {
  slideIndex = (slideIndex - 1 + totalSlides) % totalSlides;
  showSlide(slideIndex);
});
</script>

<?php include 'includes/footer.php'; ?>
</body>
</html>
