<?php
include 'includes/db.php';
include 'includes/header.php';

if (!isset($_GET['id'])) {
    echo "<p style='padding:20px;'>No service selected.</p>";
    include 'includes/footer.php';
    exit;
}

$id = intval($_GET['id']);
$result = $conn->query("SELECT * FROM Services WHERE id=$id AND is_visible=1");

if ($result->num_rows == 0) {
    echo "<p style='padding:20px;'>Service not found.</p>";
    include 'includes/footer.php';
    exit;
}

$row = $result->fetch_assoc();
?>

<style>
.service-details {
    max-width: 900px;
    margin: 60px auto;
    background: #ffffff;
    padding: 40px;
    border-radius: 14px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    font-family: "Segoe UI", sans-serif;
}

.breadcrumb {
    font-size: 14px;
    margin-bottom: 20px;
}

.breadcrumb a {
    color: #004aad;
    text-decoration: none;
    margin-right: 5px;
}

.breadcrumb span {
    margin-right: 5px;
    color: #555;
}

.back-btn {
    display: inline-block;
    margin-bottom: 20px;
    padding: 8px 15px;
    background: #004aad;
    color: #fff;
    border-radius: 8px;
    text-decoration: none;
    font-size: 14px;
}

.back-btn:hover {
    background: #003080;
}

.service-details h1 {
    font-size: 2rem;
    color: #004aad;
    margin-bottom: 25px;
    border-bottom: 3px solid #004aad;
    padding-bottom: 10px;
}

.service-info {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px 40px;
}

.service-info .item {
    display: flex;
    flex-direction: column;
}

.service-info .label {
    font-weight: bold;
    color: #1a237e;
    font-size: 15px;
    margin-bottom: 5px;
}

.service-info .value {
    font-size: 15px;
    color: #333;
    background: #f8faff;
    border-radius: 8px;
    padding: 10px 12px;
    border: 1px solid #e0e0e0;
}

.description {
    grid-column: span 2;
    margin-top: 25px;
}

.description .label {
    font-size: 16px;
    color: #1a237e;
    font-weight: bold;
}

.description .value {
    font-size: 15px;
    color: #333;
    background: #f8faff;
    border-radius: 8px;
    padding: 15px;
    border: 1px solid #e0e0e0;
    white-space: pre-wrap;
}
</style>

<div class="service-details">
    <!-- Breadcrumb -->
    <div class="breadcrumb">
        <a href="index.php">Home</a>
        <span>&gt;</span>
        <a href="services.php">Services</a>
        <span>&gt;</span>
        <span><?= htmlspecialchars($row['test_name']) ?></span>
    </div>

    <!-- Back button -->
    <a href="services.php" class="back-btn">&larr; Back to Services</a>

    <h1><?= htmlspecialchars($row['test_name']) ?></h1>
    <div class="service-info">
        <div class="item">
            <span class="label">Code</span>
            <span class="value"><?= htmlspecialchars($row['code']) ?></span>
        </div>
        <div class="item">
            <span class="label">Test Name</span>
            <span class="value"><?= htmlspecialchars($row['test_name']) ?></span>
        </div>
        <div class="item">
            <span class="label">Tube Container</span>
            <span class="value"><?= htmlspecialchars($row['tube_container']) ?></span>
        </div>
        <div class="item">
            <span class="label">Volume</span>
            <span class="value"><?= htmlspecialchars($row['volume']) ?></span>
        </div>
        <div class="item">
            <span class="label">Reporting Time</span>
            <span class="value"><?= htmlspecialchars($row['reporting_time']) ?></span>
        </div>
        <div class="item">
            <span class="label">Price</span>
            <span class="value">AFN<?= htmlspecialchars($row['price']) ?></span>
        </div>
        <div class="description">
            <span class="label">Description</span>
            <div class="value"><?= nl2br(htmlspecialchars($row['description'])) ?></div>
        </div>
        <div class="description">
            <span class="label">Preparation</span>
            <div class="value"><?= nl2br(htmlspecialchars($row['preparation'])) ?></div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
